 ; Ŀ
 ;   Pga - draw cable tags like those of a competing package.              
 ;   Copyright 1997, 2000, 2001, 2006 - 2010 by Rocket Software Ltd.       
 ;   Revised to allow modification of the block without modification       
 ;   of the routine.                                                       
 ;   Has to be able to find Puss.lsp and Misps.lsp.                        
 ;   Coffee - actually a drug which makes boredom tolerable.               
 ; 
 (DEFUN C:PGA (/ osmo tagblk *error* precol dimscl attdia orth clay plist pta
                 rhdis lhdis updis dndis blhite p1 p1a p2 dist1 p3 pd pe dir1
                     tagdis pc pb pa pf pg ph pii pj ptlist vdist tagtxt entt)
  (setvar "cmdecho" 0)
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Decide which tag block to use.                                        
 ; 
  (setq tagblk "cabletag")
  (setq tagdis 1)          ; tag dimension multiplier - for strange blocks
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
 (defun *error* (shk)
  (setvar "osmode" osmo)
  (if clay (setvar "clayer" clay))
  (if precol (setvar "cecolor" precol))
  (if attdia (setvar "attdia" attdia))
  (if orth (setvar "orthomode" orth))
 (princ))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq dimscl (misps))
 ; Ŀ
 ;   Save and change a few sysvars.                                        
 ; 
  (setq precol (getvar "cecolor"))
  (setq attdia (getvar "attdia"))
  (setq orth (getvar "orthomode"))
  (setvar "attdia" 0)
  (setvar "attreq" 1)
  (setq clay (getvar "clayer"))
 ; Ŀ
 ;   Make the Misc layer current.                                          
 ; 
  (if malaya (malaya "misc"))
 ; Ŀ
 ;   If the tag block isn't available then insert it so the definition     
 ;   can be looked at.                                                     
 ; 
  (if (null (tblsearch "block" tagblk))
      (progn
           (command ".insert" tagblk)
           (command)))
 ; Ŀ
 ;   Load the block corner point finder from Puss.lsp.                     
 ; 
  (if (not bent) (load "puss"))
 ; Ŀ
 ;   Get a list of the insertion point and block extents.                  
 ;   Bent returns a list: (insertion_point  x-max  x-min  y-max  y-min).   
 ; 
  (setq plist (bent tagblk))
  (setq pta (car plist))
  (setq rhdis (+ (car pta) (cadr plist)))         ; right hand (+x) distance
  (setq lhdis (abs (+ (car pta) (caddr plist))))  ; left hand (-x) distance
  (setq updis (+ (cadr pta) (cadddr plist)))      ; top (+y) distance
  (setq dndis (abs (+ (cadr pta) (nth 4 plist)))) ; bottom (-y) distance
  (setq blhite (+ updis dndis))                   ; overall block height
 ; Ŀ
 ;   Get some lines to tag.                                                
 ; 
  (setvar "osmode" 512)
  (if (setq p1 (getpoint "\nLine to tie leader to or <Return> for no leader:"))
      (progn
           (if (setq p1a (osnap p1 "nearest"))
               (setq p1 p1a))
           (setvar "osmode" 128)
           (setq p2 (getpoint p1 "\nNext line or <Return> if only one: "))
           (setvar "osmode" 0)
           (if (null p2) (setq p2 p1))
           (setq dist1 (distance p1 p2))
 ; Ŀ
 ;   Get the leader line points.                                           
 ; 
           (setq p3 (getpoint p2
                           "\nPick leader line points, <Return> when done: "))
           (if (> (distance p3 p1) (distance p3 p2))
               (progn
                    (setq pd p1)
                    (setq pe p2))
               (progn
                    (setq pd p2)
                    (setq pe p1)))
 ; Ŀ
 ;   The base point pd is now the furthest point from the leader side,     
 ;   pe is the closest one.                                                
 ;   Dist1 is the distance between the two points (perhaps on lines)       
 ;   or 0 if there was only one point/line selected.                       
 ; 
           (setq dir1 (angle pd p3))
 ; Ŀ
 ;   Deduce the leader end geometry points - pa is the start point.        
 ; 
           (setq pc (polar pd (+ dir1 pi) (* dimscl 2.5)))
           (setq pb (polar pc (- dir1 (/ pi 2)) (* dimscl 1.25)))
           (setq pa (polar pb dir1 (* dimscl 1.25)))
 ; Ŀ
 ;   Pd and pe have already been set, pe won't be used if they are equal.  
 ; 
           (setq pf (polar pe dir1 (* dimscl 2.5)))
           (setq pg (polar pf (- dir1 (/ pi 2)) (* dimscl 1.25)))
           (setq ph (polar pg (+ dir1 pi) (* dimscl 1.25)))
 ; Ŀ
 ;   After this the pline will retrace itself to pg and pf.                
 ; 
           (setq pii (polar pf (+ dir1 (* pi 0.5)) (* dimscl 1.25)))
           (setq pj (polar pii dir1 (* dimscl 1.25)))
 ; Ŀ
 ;   Now start the polyline.                                               
 ; 
           (setq ptlist (reverse 
                          (list pa pb pc pd pe pf pg ph pg pii pj pii pf p3)))
           (command ".pline" pa pb pc pd pe pf pg ph pg pii pj pii pf p3)
 ; Ŀ
 ;   Make the rest of the polyline - allow undo.                           
 ; 
           (initget 128)
           (while (setq pa (getpoint (car ptlist)))
                  (initget 128)
                  (if (listp pa)
                      (progn
                           (setq ptlist (cons pa ptlist))
                           (command pa))
                      (progn
                           (if (= pa "u")
                               (if (> (length ptlist) 1)
                                   (progn
                                        (setq ptlist (cdr ptlist))
                                        (command pa))
                                   (prompt "Nothing left, Bozo."))
                               (command pa)))))
           (command "")
           (setq p3 (car ptlist)))
      (progn
           (setvar "osmode" 0)
           (setq p3 (getpoint "\nTag insertion point: "))))
 ; Ŀ
 ;   Deduce the tag insertion point and flow direction.                    
 ; 
  (setvar "orthomode" 0)
  (setq pa (getpoint p3 "Tag array direction: "))
  (setvar "orthomode" orth)
  (if (< (car pa) (car p3))
      (setq p3 (polar p3 pi (* dimscl tagdis rhdis)))
      (setq p3 (polar p3 0 (* dimscl tagdis lhdis))))
  (if (> (cadr pa) (cadr p3))
      (progn
           (setq vdist (* dimscl tagdis blhite))
           (setq p3 (polar p3 (* pi 0.5) (* dimscl tagdis dndis))))
      (progn
           (setq p3 (polar p3 (* pi 1.5) (* dimscl tagdis updis)))
           (setq vdist (- (* dimscl tagdis blhite)))))
 ; Ŀ
 ;   Draw the tags.                                                        
 ; 
  (setq tagtxt "a")
  (while (/= "" tagtxt)
         (setq tagtxt " ")
         (command ".insert" tagblk p3 (* tagdis dimscl) "" 0 tagtxt)
         (setq p3 (polar p3 (/ pi 2) vdist))
         (if (= "" (setq tagtxt (getstring t "\nCable Name: ")))
             (progn
                  (entdel (entlast))
                  (redraw (entlast)))
             (progn
                  (entmod (subst (cons 1 tagtxt) (assoc 1 (setq entt (entget
                                                 (entnext (entlast))))) entt))
                  (entupd (entlast)))))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))